{
	//Horizon 3D V1.0 (build 1) © Ben Rollason. May 2010	
	
	doHorizon3D(this);

	function doHorizon3D() {
	
		var proj = app.project;
		var undoStr = "Horizon 3D";
		var activeItem = proj.activeItem;
		
		var H3D = null;
		var H3D = new Object();
		
		//basics
		H3D.scriptName = "Horizon 3D";
		H3D.version = "1.0";
		H3D.scriptTitle = H3D.scriptName + " V" + H3D.version;
		
		//UI data
		H3D.scrollSize = "[130,20]";
		H3D.eTextSize = "[30,-1]";
		H3D.eTextSize2 = "[60,-1]";
		if(parseFloat(app.version) < 9.0) H3D.eTextSize2 = "[60,16]";
		H3D.panelSize = "[190,-1]";
		
		//key data
		H3D.placement = 0;
		H3D.posIndex = 0; //can be 0,1 or 2.... corresponding to bottom of comp, compheight.2 below cam, origin
		H3D.useTriangle = 1;
		H3D.useBaseline = 0;
		H3D.useGroundfill = 0;
		
		//buttons
		H3D.strHelp = "?";
		H3D.strButton = "Create";
		H3D.strPlacementButton = "XYZ";
		
		//help and alerts
		H3D.help = "";
		H3D.help += "© Ben Rollason 2010.\nvfx.benrollason.com\n\nRun the script to create a layer that shows you the horizon line.\n\n";
		H3D.help += "Use display options to decide the placement of the ground plane and how the orientation of the horizon (i.e. which way up it is) is displayed.";
		
		H3D.tip0 = "The position of the ground plane on the Y-axis. Since the ground plane extends along the X and Z axes to an infinite distance, only the Y-axis is important to define the plane.";
		H3D.tip0 += " The default value is a Y value of the composition height, since unlike 3D programs, a floor at Y: 0 would put it above After Effects default camera position!";
		H3D.tip0 += " Change it as you see fit. It can also be altered once the horizon has been created.";
		
		H3D.tip1 = "Check this to show a small triangle on the horizon, to indicate which way is up.";
		H3D.tip2 = "Check this to show a line underneath the horizon to indicate which way is down.";
		H3D.tip3 = "Check this to fill the area that is the ground with a translucent color. This works slightly differently to the other two methods in that it can show you whether you are above or below the ground level.";
		H3D.tip3 += "If you pass through the ground level, the horizon doesn't move, but the ground fill will now appear above you. However, there is some processing overhead. The other two orientation displays are ";
		H3D.tip3 += "really fast, but this one can slow things down a little.";
				
		H3D.notEnglish = "As for most scripts, After Effects needs to be running in English for " + H3D.scriptName + " to work.";
		H3D.versionTooOld = "You need to be using After Effects CS3 or above for " + H3D.scriptName + " to work.";
		H3D.noActiveItem = "You must have a composition selected to run " + H3D.scriptName + ".";
		
		if(H3Dpreflight()) {	
				
			H3D.toolsPanel = H3DcreateUI(this);
			H3D.toolsPanel.show();
				
		}
	
		function H3Dplacement(aIndex) {
			
			//redundant method - maybe useful for future though, so I'll leave it in!
			
			var tRet;
			
			switch (aIndex) 
			
			{
			
				case 0:
					
					// original at middle bottom of default camera's view
					tRet = [activeItem.width/2, activeItem.height, 0];
					break;
					
				case 1:
				
					//origin compheight/2 below the current camera
					
					if(activeItem.activeCamera) {
						H3D.camPos = activeItem.activeCamera.transform.position.value;
						H3D.camPos = [Math.round(H3D.camPos[0]), Math.round(H3D.camPos[1]), Math.round(H3D.camPos[2])];
					} else {
						H3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(degsToRads(39.6/2)))];
					}
					
					tRet = H3D.camPos + [0, activeItem.height/2, 0]; 
					break;
					
				case 2:
				
					//origin at world origin
					tRet = [0,0,0];
					break;
					
				case 3:
				
					//origin at middle bottom of current camera's view
					//this is work in progress and requires a math version of expression language's toWorld function.
					
					if(activeItem.activeCamera) {
						H3D.camPos = activeItem.activeCamera.transform.position.value;
					} else {
						H3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(degsToRads(39.6/2)))];
					}
					
					tRet = [0,0,0];//tRet = ??
					break;
					
				default:
				
					tRet = [activeItem.width/2, activeItem.height, 0];
					break;
					
				
			}
		
			return(tRet);
			
			
		}
	
		function H3DdegsToRads(degs) {
			return(Math.PI*2*degs/360);
		}
	
	
		function H3Dpreflight() {
				
			var isEnglish = ((app.isoLanguage == "en_US") || (app.language == Language.ENGLISH));
			var appVersionTooOld = (parseFloat(app.version) < 8.0)
	
			if(appVersionTooOld) {
				alert(H3D.versionTooOld);
				return(false);
			} else if (!isEnglish) {
				alert(H3D.notEnglish);
				//alert("Current language code: "+ app.language);
				return(false);
			} else {
				return(true);
			}
		
		}
		
	
		function H3DcreateUI(thisObj) {
			
			var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", H3D.scriptName, undefined, {resizeable:true}); //replace undefined with [300,300,570,550]??
				
			if (pal != null) {
				
				if(activeItem && (activeItem != null) && (activeItem instanceof CompItem)) {
					H3D.placement = activeItem.height;
				} else {
					H3D.placement = 0;
				}
					
				var res =
					"group { \
						orientation:'column', alignment:['left','top'], \
						Panel1: Panel { text: 'Ground Placement', orientation: 'row', minimumSize:" + H3D.panelSize + ", margins: 15, spacing: 5, \
							Gr1: Group {\
								alignment:['left','center'], minimumSize: [120,-1],  spacing:15,\
								placementYText: StaticText { text:'Y-axis', preferredSize:[-1,-1], alignment:['left','center'] }, \
								placementYEditText: EditText { text:'" + H3D.placement + "', characters:6, preferredSize:" + H3D.eTextSize2 + ", alignment:['left','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','center'], spacing:15,\
								tip0: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
							}\
						}\
						Panel2: Panel { text: 'Display Options', orientation: 'column', minimumSize:" + H3D.panelSize + ", margins:15, spacing: 5, \
							Gr1: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr1a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									triangleText: StaticText { text:'Triangle:', minimumSize:[60,-1], alignment:['left','center'] }, \
									triangleCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + H3D.useTriangle + ", preferredSize: [25,25],},\
								}\
								Gr1b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip1: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr2: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr2a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									baselineText: StaticText { text:'Base line:', minimumSize:[60,-1], alignment:['left','center'] }, \
									baselineCheckbox:Checkbox {text:'',alignment:['left','center'],value: " + H3D.useBaseline + ", preferredSize: [25,25],},\
								}\
								Gr2b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip2: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr3: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr3a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									groundfillText: StaticText { text:'Ground fill:', minimumSize:[60,-1], alignment:['left','center'] }, \
									groundfillCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + H3D.useGroundfill + ", preferredSize: [25,25],},\
								}\
								Gr3b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip3: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
						}\
						footer: Group { \
							alignment:['right','top'], \
							help: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['left','center'] }, \
							mainButton: Button { text:'" + H3D.strButton +"', preferredSize:[60,20], alignment:['right','center'] }, \
						}, \
					}";
					
					
				pal.grp = pal.add(res);
				
				var darkBrush = pal.graphics.newPen(pal.graphics.BrushType.SOLID_COLOR, [0,0,0], 1);
				pal.grp.Panel1.Gr1.placementYEditText.graphics.foregroundColor  = darkBrush;
				
				pal.layout.layout(true);
				pal.grp.minimumSize = pal.grp.size;
				pal.layout.resize();
				pal.onResizing = pal.onResize = function () {this.layout.resize();}
				//pal.onFocus = alert("focus");
				
				pal.grp.Panel1.Gr1.placementYEditText.onChange = function() 
				{
					if (isNaN(this.text)) this.text = H3D.placement;
					H3D.placement = parseFloat(this.text);
				}
				pal.grp.Panel1.Gr2.tip0.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.tip0, H3D.scriptName);}
				pal.grp.Panel2.Gr1.Gr1b.tip1.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.tip1, H3D.scriptName);}
				pal.grp.Panel2.Gr2.Gr2b.tip2.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.tip2, H3D.scriptName);}
				pal.grp.Panel2.Gr3.Gr3b.tip3.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.tip3, H3D.scriptName);}
				
				pal.grp.Panel2.Gr1.Gr1a.triangleCheckbox.onClick = function () {H3D.useTriangle = pal.grp.Panel2.Gr1.Gr1a.triangleCheckbox.value}
				pal.grp.Panel2.Gr2.Gr2a.baselineCheckbox.onClick = function () {H3D.useBaseline = pal.grp.Panel2.Gr2.Gr2a.baselineCheckbox.value}
				pal.grp.Panel2.Gr3.Gr3a.groundfillCheckbox.onClick = function () {H3D.useGroundfill = pal.grp.Panel2.Gr3.Gr3a.groundfillCheckbox.value}
				
				
				pal.grp.footer.help.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.help, H3D.scriptName);}
				pal.grp.footer.mainButton.onClick = H3DmainFunction;
				
				
			
				
			} //if (pal != null)
		
			return(pal);
			
		} // function createUI
		

		function H3Dtrace(s) {
			$.writeln(s); // writes to the ExtendScript interface
			//writeLn("3DR: " + s); // writes in the AE info window
		}
	
		function H3DreturnFunctionVectorIntersectPlane() {
			
			var tJS = "";
			
			tJS += "function vectorIntersectPlane(aVectorPoint, aVectorNormal, aPlanePoint, aPlaneNormal) {\n";
			tJS += "\tP0 = aVectorPoint;\n";
			tJS += "\tu = aVectorNormal;\n";
			tJS += "\tV0 = aPlanePoint;\n";
			tJS += "\tn = aPlaneNormal;\n";
			tJS += "\tw = P0 - V0;\n";
			tJS += "\tif(dot(n,u) != 0) {\n";
			tJS += "\t\ts = dot(-n,w) /  dot(n,u);\n";
			tJS += "\t\tr = P0 + s*u;\n";
			tJS += "\t\treturn(r);\n";
			tJS += "\t} else {\n";
			tJS += "\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\tif(dot(n, w) == 0) {\n";
			tJS += "\t\t\t//the point is on the plane\n";
			tJS += "\t\t\treturn(P0);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\treturn(-1);\n";
			tJS += "\t\t}\n";
			tJS += "\t}\n";
			tJS += "}\n";			
			
			return(tJS);			
		}
	
		function H3DreturnFunctionFromWorlUniversal() {
			
			var tJS = "";
			
			tJS += "function fromWorldUniversal(aPlaneNormal, aPlanePoint, aPlaneXNormal, aPoint) {\n";
			tJS += "\taPlaneYNormal = normalize(cross(aPlaneNormal, aPlaneXNormal));\n";
			tJS += "\ttZ = dot(aPoint - aPlanePoint, aPlaneNormal);\n";
			tJS += "\ttY = dot(aPoint - aPlanePoint, aPlaneYNormal);\n";
			tJS += "\ttX = dot(aPoint - aPlanePoint, aPlaneXNormal);\n";
			tJS += "\treturn([tX,tY,tZ]);\n";
			tJS += "}\n\n";
			
			return(tJS);
			
		}
	
		function H3DreturnFunctionRoundToDecimalPlaces() {
			
			var tJS = "";
			
			tJS += "function roundToDecimalPlaces(aNumOrArray, aDP) {\n";
			tJS += "\ttIsArray = aNumOrArray instanceof Array;\n";
			tJS += "\ttIsNum = (typeof aNumOrArray == 'number') || (aNumOrArray instanceof Number);\n";
			tJS += "\tif(tIsArray) {\n";
			tJS += "\t\tfor (i in aNumOrArray) {\n";
			tJS += "\t\t\tif((typeof aNumOrArray[i] == 'number') || (aNumOrArray[i] instanceof Number)) {\n";
			tJS += "\t\t\t\taNumOrArray[i] = Math.round(aNumOrArray[i]*Math.pow(10, aDP))/Math.pow(10,aDP);\n";
			tJS += "\t\t\t\t//aNumOrArray[i] = aNumOrArray.toFixed(aDP);\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t}\n";
			tJS += "\t} else if (tIsNum) {\n";
			tJS += "\t\taNumOrArray = Math.round(aNumOrArray*Math.pow(10, aDP))/Math.pow(10,aDP);\n";
			tJS += "\t\t//aNumOrArray = aNumOrArray.toFixed(aDP);\n";
			tJS += "\t}\n";
			tJS += "\treturn(aNumOrArray);\n";
			tJS += "}\n\n";
				
			return(tJS);
		}
	
		function H3DreturnInitialTryStatement(aC, aCPos, aCPlV, aCPlX, aCPlY, aCPlP, aScrPlP) {
					
			var tJS = "";
			var tJS2 = "";
			var tJS3 = "";
			
			tJS += "try {\n";
			if(aC) tJS += "\tC = thisComp.activeCamera;\n";
			if(aCPos) tJS += "\tCPos = C.toWorld([0,0,0]);\n";
			if(aCPlV) tJS += "\tCPlV = C.toWorldVec([0,0,1]);\n";
			if(aCPlX) tJS += "\tCPlX = C.toWorldVec([1,0,0]);\n";
			if(aCPlY) tJS += "\tCPlY = C.toWorldVec([0,1,0]);\n";
			if(aCPlP) tJS += "\tCPlP = CPos + CPlV*Math.pow(10,9); //the world position of the big screen (1,000,000 from the camera)\n";
			if(aScrPlP) tJS += "\tScrPlP = CPos + CPlV*C.cameraOption.zoom; //the world position of the normal screen\n";
			tJS+= "} catch(e) {\n";
			
			tJS2 += "\ttry {\n";
			if(aC) tJS2 += "\t\tC = thisComp.layer(\"default cam pos\");\n";
			if(aCPos) tJS2 += "\t\tCPos = C.toWorld([0,0,0]);\n";
			if(aCPlV) tJS2 += "\t\tCPlV = C.toWorldVec([0,1,0]);\n";
			if(aCPlX) tJS2 += "\t\tCPlX = C.toWorldVec([1,0,0]);\n";
			if(aCPlY) tJS2 += "\t\tCPlY = C.toWorldVec([0,1,0]);\n";
			if(aCPlP) tJS2 += "\t\tCPlP = CPos + CPlV*Math.pow(10,9); //the world position of the big screen (1,000,000 from the camera)\n";
			if(aScrPlP) tJS2 += "\t\tScrPlP = CPos - CPlV*C.position[2];\n";
			tJS2 += "\t} catch(e) {\n";
			if(aCPos) tJS2 += "\t\tCPos = [thisComp.width/2, thisComp.height/2, (-thisComp.width/2) / Math.tan(degreesToRadians(39.6/2))];\n";
			if(aCPlV) tJS2 +=  "\t\tCPlV = [0,0,1];\n";
			if(aCPlX) tJS2 += "\tCPlX = [1,0,0];\n";
			if(aCPlY) tJS2 += "\t\tCPlY = [0,1,0];\n";
			if(aCPlP) tJS2 += "\t\tCPlP = CPlV*Math.pow(10,9) +CPos;\n";
			if(aScrPlP) tJS2 == "\t\tScrPlP = CPos - CPlV*CPos[2];\n";
			tJS2 += "\t}\n";
			tJS2 += "}\n\n";
			
			if(aCPos) tJS3 += "\tCPos = [thisComp.width/2, thisComp.height/2, (-thisComp.width/2) / Math.tan(degreesToRadians(39.6/2))];\n";
			if(aCPlV) tJS3 +=  "\tCPlV = [0,0,1];\n";
			if(aCPlX) tJS3 += "\tCPlX = [1,0,0];\n";
			if(aCPlY) tJS3 += "\tCPlY = [0,1,0];\n";
			if(aCPlP) tJS3 += "\tCPlP = CPlV*Math.pow(10,9) +CPos;\n";
			if(aScrPlP) tJS3 += "\tScrPlP = CPos - CPlV*CPos[2];\n";
			tJS3 += "}\n\n";
			
			//return(tJS + tJS2); //long version
			return(tJS + tJS3);
		
		}
	
		function H3DreturnFunctionVectorPointToLine() {

			var tJS = "";
			
			tJS += "function vectorPointToLine2D(linePoint, lineVector, point) {\n";
			tJS += "\tv0 = linePoint - point;\n";
			tJS += "\tlinePerp = normalize([-lineVector[1], lineVector[0]]);\n";
			tJS += "\tif(length(lineVector) > 0) {\n";
			tJS += "\t\td = dot(v0, linePerp);\n";
			tJS += "\t\treturn(d*linePerp);\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn([-1000,-1000]);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";

			return(tJS);
		}
	
		function H3DreturnFunctionVectorPointToLine2D() {
			
			var tJS = "";
			
			tJS += "function vectorPointToLine2D(linePoint, lineVector, point) {\n";
			tJS += "\tv0 = linePoint - point;\n";
			tJS += "\tlinePerp = normalize([-lineVector[1], lineVector[0]]);\n";
			tJS += "\tif(length(lineVector) > 0) {\n";
			tJS += "d = dot(v0, linePerp);\n";
			tJS += "\t\treturn(d*linePerp);\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn([-1000,-1000]);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			
			return(tJS);		
			
		}
	
	
		function H3DreturnFunctionIsFacingNormals(){
		
			var tJS = "";
			
			tJS += "function isFacingNormals(Point1, Normal1, Point2, Normal2, aLookAtEachOther) {\n";
			tJS += "\tw = Point1 - Point2;\n";
			tJS += "\tif(dot(Normal2,Normal1) != 0) {\n";
			tJS += "\t\ts1 = dot(-Normal2,w) /  dot(Normal2,Normal1);\n";
			tJS += "\t} else {\n";
			tJS += "\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\t//so it doesn't really matter what value we give s\n";
			tJS += "\t\ts1 = 0;\n";
			tJS += "\t}\n";
			tJS += "\tif(aLookAtEachOther) {\n";
			tJS += "\t\t//now switch it round\n";
			tJS += "\t\tw = Point2 - Point1;\n";
			tJS += "\t\tif(dot(Normal1,Normal2) != 0) {\n";
			tJS += "\t\t\ts2 = dot(-Normal1,w) /  dot(Normal1,Normal2);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\t\t//so it doesn't really matter what value we give s\n";
			tJS += "\t\t\ts2 = 0;\n";
			tJS += "\t\t}\n";
			tJS += "\t\tif (s1 ==0 || s2 == 0) {\n";
			tJS += "\t\t\treturn(-1);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\treturn(s2 < 0 && s1 <0);\n";
			tJS += "\t\t}\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn(s1 < 0);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			
			return(tJS);
		
		}
	
		function H3DreturnFunctionPlaneIntersectPlaneUniversal() {
		
			var tJS = "";
			
			tJS +="function planeIntersectPlaneUniversal(n1, n2, P1, P2) {\n";
			tJS += "\tif ((n1 == n2) || (n1 == -n2)) {\n";
			tJS += "\t\t//planes are parallel\n";
			tJS += "\t\treturn(-1);\n";
			tJS += "\t} else {\n";
			tJS += "\t\tV = cross(n1,n2);\n";
			tJS += "\t\t//get point\n";
			tJS += "\t\t//to find any specific point on the line, take an arbitrary vector on the first plane\n";
			tJS += "\t\t//and use code from vectorIntersectPlane to find where it meets the second plane.\n";
			tJS += "\t\t//this is of course, also on the line.\n";
			tJS += "\t\tx1 = cross(n1, n1+[20,0,0]); //get x normal (arbitrary perpendicular to n1)\n";
			tJS += "\t\ty1 = cross(n1, x1);// and y normal - perpendicular to both\n";
			tJS += "\t\tP1a = P1 + 1000*normalize(x1) + 1000*normalize(y1); //an arbitrary point on Plane 1's surface\n";
			tJS += "\t\tu = P1a-P1; //an arbitrary vector on it's surface\n";
			tJS += "\t\tP = vectorIntersectPlane(P1, u, P2, n2);\n";
			tJS += "\t\tif(P == -1) {\n";
			tJS += "\t\t\t//we have been unlucky with our arbitrarily chosen vector. It is parallel to the plane.\n";
			tJS += "\t\t\t//Since we know the planes are not parallel, we try again with another slightly different vector.\n";
			tJS += "\t\t\t//It isn't possible that the second one doesn't meet it.\n";
			tJS += "\t\t\tP1a = P1 + 1000*normalize(x1) + 900*normalize(y1); //an arbitrary point on Plane 1's surface\n";
			tJS += "\t\t\tu = P1a-P1; //an arbitrary vector on it's surface\n";
			tJS += "\t\t\tP = vectorIntersectPlane(P1, u, P2, n2);\n";
			tJS += "\t\t}\n";
			tJS += "\t\treturn([P,V]); // point and vector that describe the line of intersection\n";
			tJS += "\t}\n";				   
			tJS += "}\n\n";
			
			return(tJS);			
			
		}
	
		function H3DreturnBeamTriangle1JS(argWhich, argStartOrFinish) { //arg should be 1 or 2, depending on which triangle it is //1 or 2 for start or finish
			
			var tJS = "";
			
			tJS += H3DreturnInitialTryStatement(1,0,0,0,1,0,0);
			
			tJS += "HPlV = [0,1,0]; //ground normal\n";
			tJS += "upsideDown = dot(CPlY, HPlV) < 0;\n";
			tJS += "if(effect(\"H3D: Triangle point up\")(\"Checkbox\")<0.5) upsideDown = !upsideDown;\n";
			tJS += "\ttStart = effect(\"H3D: Beam (main)\")(\"Starting Point\");\n";
			tJS += "\ttEnd = effect(\"H3D: Beam (main)\")(\"Ending Point\");\n";
			tJS += "\ttVec  = tEnd - tStart;\n";
			tJS += "\tcompMid = [thisComp.width/2, thisComp.height/2];\n";
			tJS += "\ttMid = compMid + vectorPointToLine2D(tStart, tVec, compMid);\n";
			tJS += "\tif(length(tVec) > 0) {\n";
			//tJS += "\t\tif(thisProperty.name == \"Starting Point\") {\n";
			if(argStartOrFinish == 1) {
				tJS += "\t\ttMid" + ((argWhich == 1) ? " + " : " - ") + "normalize(tVec)*effect(\"H3D: Triangle height / width\")(\"Point\")[1]/2;\n";
			} else {
				//tJS += "\t} else {\n";
				tJS += "\t\ttMid +effect(\"H3D: Triangle height / width\")(\"Point\")[0]*(upsideDown*2-1)*normalize([-tVec[1], tVec[0]]);\n";
			}
			//tJS += "\t}\n";
			tJS += "} else {\n";
			tJS += "\t[-1000,-1000];\n";
			tJS += "}\n\n";
			
			tJS += "//____________________________________FUNCTIONS____________________________________\n\n";
			
			tJS += H3DreturnFunctionVectorPointToLine2D();
			
			return(tJS);

			
			
		}
	
		function H3DreturnBeamBaseLine(argStartOrFinish) {
			
			var tJS = "";
			
			tJS += H3DreturnInitialTryStatement(1,0,0,0,1,0,0);
			
			tJS += "HPlV = [0,1,0]; //ground normal\n";
			tJS += "upsideDown = dot(CPlY, HPlV) < 0;\n";
			tJS += "if(effect(\"H3D: Triangle point up\")(\"Checkbox\")<0.5) upsideDown = !upsideDown;\n";
			tJS += "\ttStart = effect(\"H3D: Beam (main)\")(\"Starting Point\");\n";
			tJS += "\ttEnd = effect(\"H3D: Beam (main)\")(\"Ending Point\");\n";
			tJS += "\ttVec  = tEnd - tStart;\n";
			tJS += "\tcompMid = [thisComp.width/2, thisComp.height/2];\n";
			tJS += "\ttMid = compMid + vectorPointToLine2D(tStart, tVec, compMid);\n";
			//same as triangle to this point... and beyond functions line
			tJS += "tDist = effect(\"H3D: Base line distance / width\")(\"Point\")[0];\n";
			tJS += "tLength = effect(\"H3D: Base line distance / width\")(\"Point\")[1]/2;\n";
			tJS += "if(length(tVec) > 0) {\n";
			tJS += "\ttPerpUnit = (upsideDown*2-1)*normalize([-tVec[1], tVec[0]]);\n";
			tJS += "\ttParllUnit = (upsideDown*2-1)*normalize(tVec);\n";
			//tJS += "\tif(thisProperty.name == \"Starting Point\") {\n";
			if(argStartOrFinish == 1) {
				tJS += "\t\ttMid + tDist*tPerpUnit + tLength*tParllUnit;\n";
				//tJS += "\t} else {\n";
			} else {
				tJS += "\t\ttMid + tDist*tPerpUnit - tLength*tParllUnit;\n";
				//tJS += "\t}\n";
			}
			tJS += "} else {\n";
			tJS += "\t[-1000,-1000];\n";
			tJS += "}\n\n";
			
			tJS += "//____________________________________FUNCTIONS____________________________________\n\n";
			
			tJS += H3DreturnFunctionVectorPointToLine2D();
			
			return(tJS);
			
		}
	
	
	
		function H3DreturnBeamMainStartingEndingJS(argStartOrFinish) {
			
			var debugging_version = false;
			
			var tJS = "";
			
			tJS += H3DreturnInitialTryStatement(1,1,1,1,0,1,1);
			
			tJS += "HPlP = [effect(\"H3D: Ground Coords XY\")(\"Point\")[0],effect(\"H3D: Ground Coords XY\")(\"Point\")[1],effect(\"H3D: Ground Coords Z\")(\"Slider\")]; //ground position\n";
			tJS += "HPlV = [0,1,0]; //ground normal\n\n";
			
			tJS += "worldLine = planeIntersectPlaneUniversal(CPlV, HPlV, CPlP, HPlP);\n";
			tJS += "//world line is a point and a vector, expressing the intersection in worldspace.\n\n";
			
			tJS += "//planeLine is worldLine expressed in the layer space of the distant camera plane\n";
			tJS += "//because the plane is hypothetical, it needs to use a customised fromWorld function\n\n";
			
			tJS += "planeLine0 = fromWorldUniversal(CPlV, CPlP, CPlX, worldLine[0]); //point\n";
			tJS += "planeLine1 = fromWorldUniversal(CPlV, CPlP, CPlX, worldLine[0] + 100*worldLine[1]) - planeLine0; //vector\n";
			tJS += "planeLine = [planeLine0, planeLine1]; //expresses worldLine in the 'layer space' of the plane 1000000 away from the camera (only [0,0] is in the middle not at the top left)\n\n";

			tJS += "//screenPlaneLine is planeLine projected back to the screen plane, using the ratio of the two plane's sizes\n";
			tJS += "//hence it gives worldLine in comp space coords. the vector needn't be scaled. It doesn't change anything\n";
			tJS += "//[compWidth/2, compHeight/2] is added to convert to comp space, since the hypothetical plane's [0,0] is directly in front of the camera.\n\n";

			tJS += "tRatio = length(ScrPlP, CPos) / length(CPlP,CPos); //the ratio of the two plane's distances from camera.\n";
			tJS += "screenPlaneLine0 = [thisComp.width/2, thisComp.height/2] + [tRatio*planeLine0[0], tRatio*planeLine0[1]]; //this is now the point element of the horizon line in screen coordinates (I hope)\n";
			tJS += "screenPlaneLine1 = planeLine1;\n";
			tJS += "screenPlaneLine = [screenPlaneLine0, screenPlaneLine1];\n\n";
			
			tJS += "//find where (if not parallel) it crosses screen right and screen left\n";
			tJS += "if(planeLine1[0] != 0) {\n";
			tJS += "\txL = (0-screenPlaneLine[0][0]) / screenPlaneLine[1][0]; //xL is the scalar amount to travel from the point along the vector to reach the left edge or x = 0\n";
			tJS += "\txR = (thisComp.width-screenPlaneLine[0][0]) / screenPlaneLine[1][0]; //xR is the scalar amount to travel from the point along the vector to reach the right edge or x = thisComp.width\n\n";
	
			tJS += "\txYL = screenPlaneLine[0][1] + xL*screenPlaneLine[1][1] ;//the Y value where it crosses Left\n";
			tJS += "\txYR = screenPlaneLine[0][1] + xR*screenPlaneLine[1][1];//the Y value where it crosses Right\n\n";
			
			tJS += "\txYL = (xYL>=0 && xYL <= thisComp.height) ? [0,xYL] : -1;\n";
			tJS += "\txYR = (xYR>=0 && xYR <= thisComp.height) ? [thisComp.width,xYR] : -1;\n";
			tJS += "} else {\n";
			tJS += "\t//the line is vertical and doesn't cross\n";
			tJS += "\txYL = -1;\n";
			tJS += "\txYR = -1;\n";
			tJS += "}\n\n";
			
			tJS += "//find where (if not parallel) it crosses screen top and bottom\n";
			tJS += "if(planeLine1[1] != 0) {\n";
			tJS += "\txT = (0-screenPlaneLine0[1]) / planeLine1[1];\n";
			tJS += "\txB = (thisComp.height - screenPlaneLine0[1]) / planeLine1[1];\n";
			tJS += "\txXT = screenPlaneLine0[0] + xT*planeLine1[0]; //the X value where it crosses Top\n";
			tJS += "\txXB = screenPlaneLine0[0] + xB*planeLine1[0]; //the X value where it crosses Bottom\n\n";

			tJS += "\txXT = (xXT >= 0 && xXT <= thisComp.width) ? [xXT,0] : -1;\n";
			tJS += "\txXB = (xXB >= 0 && xXB <= thisComp.width) ? [xXB,thisComp.height] : -1;\n";
			tJS += "} else {\n";
			tJS += "\txXT = -1;\n";
			tJS += "\txXB = -1;\n";
			tJS += "}\n\n";
			
			tJS += "tStart = " + ((argStartOrFinish == 1) ? "true;\n" : "false;\n"); //thisProperty.name == \"Starting Point\";\n";
			
			//the following are new lines to get round the x-90 bug
			tJS += "try {aMult = (C.toCompVec(C.fromWorldVec([0,1,0]))[0] < 0) && (planeLine1[0] ==0)}catch(e){aMult = 0}\n";
			tJS += "if(aMult) tStart = !tStart;\n";
			//to here
			
			tJS += "tCount = 0;\n";
			tJS += "tValidPointList = [];\n\n";
			
			tJS += "for (var i = 0; i < 4; i++) {\n";
			tJS += "\tvar xList = [xYL, xYR, xXT, xXB];\n";
			tJS += "\tif(xList[i] != -1) {\n";
			tJS += "\t\ttValidPointList.push(xList[i]);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			
			tJS += "tMinToCountAsEqual = 0.0001;\n\n";
			
			tJS += "if(tValidPointList.length>1) {\n";
			tJS += "\tif(tStart) {\n";
			tJS += "\t\t//find lowest x and put it in Starting Point\n";
			tJS += "\t\t//if x is too close, then put lowest y in Starting Point\n";
			tJS += "\t\tif(Math.abs(tValidPointList[0][0] - tValidPointList[1][0]) < tMinToCountAsEqual) {\n";
			tJS += "\t\t\tif(tValidPointList[0][1] < tValidPointList[1][1]) {\n";
			tJS += "\t\t\t\ttValidPointList[1];\n";
			tJS += "\t\t\t} else {\n";
			tJS += "\t\t\t\ttValidPointList[0];\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t} else if (tValidPointList[0][0] < tValidPointList[1][0]) {\n";
			tJS += "\t\t\ttValidPointList[0];\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\ttValidPointList[1];\n";
			tJS += "\t\t}\n";
			tJS += "\t} else {\n";
			tJS += "\t\tif(Math.abs(tValidPointList[0][0] - tValidPointList[1][0]) < tMinToCountAsEqual) {\n";
			tJS += "\t\t\tif(tValidPointList[0][1] > tValidPointList[1][1]) {\n";
			tJS += "\t\t\t\ttValidPointList[1];\n";
			tJS += "\t\t\t} else {\n";
			tJS += "\t\t\t\ttValidPointList[0];\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t} else if (tValidPointList[0][0] > tValidPointList[1][0]) {\n";
			tJS += "\t\t\ttValidPointList[0];\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\ttValidPointList[1];\n";
			tJS += "\t\t}\n";
			tJS += "\t}\n";
			tJS += "} else {\n";
			tJS += "\t[-1000,-1000];\n";
			tJS += "}\n\n";
			
			if(debugging_version) {
				//the following lines are for debugging.
				tJS += "if(thisLayer.name == \"debug\") {\n";
				tJS += "\troundToDecimalPlaces(worldLine[0],2);\n";
				tJS += "\tCPlP;\n";
				tJS += "\tScrPlP;\n";
				tJS += "\tworldLine[0];\n";
				tJS += "\ttValidPointList.length;\n";
				tJS += "\ttStr = \"\";\n";
				tJS += "\tif(xYL != -1) {\n";
				tJS += "\t\ttStr += \"xYL: [ \" + Math.round(parseFloat(xYL[0])*10)/10 + \", \" + Math.round(parseFloat(xYL[1])*10)/10 +  \"]\\r\";\n";
				tJS += "\t} else {\n";
				tJS += "\t\ttStr += \"xYL: \" + xYL + \"\r\";\n";
				tJS += "\t}\n";
				tJS += "\tif(xYR != -1) {\n";
				tJS += "\t\ttStr += \"xYR: [ \" + Math.round(parseFloat(xYR[0])*10)/10 + \", \" + Math.round(parseFloat(xYR[1])*10)/10 +  \"]\\r\";\n";
				tJS += "\t} else {\n";
				tJS += "\t\ttStr += \"xYR: \" + xYR + \"\\r\";\n";
				tJS += "\t}\n";
				tJS += "\tif(xXT != -1) {\n";
				tJS += "\t\ttStr += \"xXT: [ \" + Math.round(parseFloat(xXT[0])*10)/10 + \", \" + Math.round(parseFloat(xXT[1])*10)/10 +  \"]\\r\";\n";
				tJS += "\t} else {\n";
				tJS += "\t\ttStr += \"xXT: \" + xXT + \"\\r\";\n";
				tJS += "\t}\n";
				tJS += "\tif(xXB != -1) {\n";
				tJS += "\t\ttStr += \"xXB: [ \" + Math.round(parseFloat(xXB[0])*10)/10 + \", \" + Math.round(parseFloat(xXB[1])*10)/10 +  \"]\\r\";\n";
				tJS += "\t} else {\n";
				tJS += "\t\ttStr += \"xXB: \" + xXB + \"\\r\";\n";
				tJS += "\t}\n";
				tJS += "}\n\n";
				
			}//if(debugging_version)
	
			tJS += "//____________________________________FUNCTIONS____________________________________\n\n";
			
			tJS += H3DreturnFunctionPlaneIntersectPlaneUniversal();

			tJS += H3DreturnFunctionFromWorlUniversal();

			tJS += H3DreturnFunctionVectorIntersectPlane();

			if(debugging_version) {
				//if creating a debugging version
				tJS += H3DreturnFunctionRoundToDecimalPlaces();
			}
			
			//___________________________
			
			return(tJS);
			
			//___________________________

		}
	
		function H3DreturnBeamFloorStartingEndingJS(argStartFinish) { //1 for start 2 for finish
				
			var tJS = "";
			
			tJS += H3DreturnInitialTryStatement(1,1,1,0,1,0,0) 
			
			tJS += "HPlP = [effect(\"H3D: Ground Coords XY\")(\"Point\")[0],effect(\"H3D: Ground Coords XY\")(\"Point\")[1],effect(\"H3D: Ground Coords Z\")(\"Slider\")]; //ground position\n";
			tJS += "HPlV = [0,1,0]; //ground normal\n\n";

			tJS += "upsideDown = dot(CPlY, HPlV) < 0;\n";
			tJS += "tAboveFloor = dot((HPlP - CPos), HPlV) > 0;\n";
			tJS += "if(!tAboveFloor) upsideDown = !upsideDown;\n";
			tJS += "if(effect(\"H3D: Triangle point up\")(\"Checkbox\")<0.5) upsideDown = !upsideDown;\n\n";

			tJS += "tStart = effect(\"H3D: Beam (main)\")(\"Starting Point\");\n";
			tJS += "tEnd = effect(\"H3D: Beam (main)\")(\"Ending Point\");\n";
			tJS += "tVec  = tEnd - tStart;\n";
			tJS += "compMid = [thisComp.width/2, thisComp.height/2];\n";
			tJS += "tMid = compMid + vectorPointToLine2D(tStart, tVec, compMid);\n\n";

			tJS += "tDist = -thisProperty.propertyGroup(1)(\"Starting Thickness\")/2;\n";
			tJS += "tLength = length(tVec) + thisProperty.propertyGroup(1)(\"Starting Thickness\");\n\n";

			tJS += "if(length(tVec) > 0) {\n";
			tJS += "\ttPerpUnit = (upsideDown*2-1)*normalize([-tVec[1], tVec[0]]);\n";
			tJS += "\ttParllUnit = (upsideDown*2-1)*normalize(tVec);\n";
			//tJS += "\tif(thisProperty.name == \"Starting Point\") {\n";
			if(argStartFinish == 1) {
				tJS += "\t\ttMid + tDist*tPerpUnit + tLength*tParllUnit;\n";
				//tJS += "\t} else {\n";
			} else {
				tJS += "\t\ttMid + tDist*tPerpUnit - tLength*tParllUnit;\n";
				//tJS += "\t}\n";
			}
			tJS += "} else {\n";
			tJS += "\tif(!isFacingNormals(CPos, CPlV, HPlP, HPlV, false)) {\n";
			//tJS += "\t\tif(thisProperty.name == \"Starting Point\") {\n";
			if(argStartFinish == 1) {
				tJS += "\t\t\t[-thisComp.width/2, thisComp.height/2];\n";
			} else {//tJS += "\t\t} else {\n";
				tJS += "\t\t\t[thisComp.width*1.5, thisComp.height/2];\n";
			//tJS += "\t\t}\n";
			}
			tJS += "\t} else {\n";
			tJS += "\t\t[-thisProperty.propertyGroup(1)(\"Starting Thickness\"),-thisProperty.propertyGroup(1)(\"Starting Thickness\")];\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			tJS += "//____________________________________FUNCTIONS____________________________________\n\n";
			
			tJS += H3DreturnFunctionVectorPointToLine();

			tJS += H3DreturnFunctionIsFacingNormals();

			return(tJS);			
			
		}
	
		function H3DmainFunction() {
			//MAIN FUNCTION
			
			app.beginUndoGroup(undoStr);
			
			activeItem = proj.activeItem;
			if (!activeItem || ! activeItem instanceof CompItem){
				alert(H3D.noActiveItem);
			} else {
				
				//create a 2D layer and name it
				H3D.layer = activeItem.layers.addSolid([0,0,0], H3D.scriptName, activeItem.width, activeItem.height, activeItem.pixelAspect, activeItem.duration);
				H3D.layer.name = H3D.scriptName;
				
				//add effects.
				
				tCount = 0;
				
				FX = H3D.layer("Effects");
				
				var lineThick = FX.addProperty("ADBE Point Control");
				lineThick.name = "H3D: Line thickness 1/2";
				lineThick(1).setValue([4,2]);
				tCount++;
				
				var Clr1 = FX.addProperty("ADBE Color Control");
					Clr1.name = "H3D: Color 1";
					Clr1(1).setValue([1,1,0]);
					tCount++;
				
				if(H3D.useTriangle || H3D.useBaseline) {
					var Clr2 = FX.addProperty("ADBE Color Control");
					Clr2.name = "H3D: Color 2";
					Clr2(1).setValue([1,1,0]);
					tCount++;
				}
			
				if(H3D.useGroundfill) {			
					var Clr3 = FX.addProperty("ADBE Color Control");
					Clr3.name = "H3D: Color 3";
					Clr3(1).setValue([0.5,1,0.5]);
					tCount++;
				}
				
				if(H3D.useTriangle) {
					var triangleHeight = FX.addProperty("ADBE Point Control");
					triangleHeight.name = "H3D: Triangle height / width";
					triangleHeight(1).setValue([10,20]);
					tCount++;
				}
			
				if(H3D.useTriangle || H3D.useBaseline || H3D.useGroundfill) {
				
					var triangleUp = FX.addProperty("ADBE Checkbox Control");
					triangleUp.name = "H3D: Triangle point up";
					triangleUp(1).setValue(1);
					tCount++;
				}
			
				if(H3D.useBaseline) {
				
					var baseLineDist = FX.addProperty("ADBE Point Control");
					baseLineDist.name = "H3D: Base line distance / width";
					baseLineDist(1).setValue([-20,250]);
					tCount++;
					
				}
				
				var groundCoordsXY = FX.addProperty("ADBE Point Control");
				groundCoordsXY.name = "H3D: Ground Coords XY";
				groundCoordsXY(1).setValue([activeItem.width/2,H3D.placement]);
				tCount++;
				
				var groundCoordsZ = FX.addProperty("ADBE Slider Control");
				groundCoordsZ.name = "H3D: Ground Coords Z";
				groundCoordsZ(1).setValue(0);
				tCount++;
				
				var setChannels = FX.addProperty("ADBE Set Channels");
				setChannels.name = "H3D: Set Channels";
				setChannels(8).setValue(10);
				tCount++;
				
				//MAIN HORIZON BEAM. - ultimately must be moved to the end
				var mainBeam = FX.addProperty("ADBE Laser");
				mainBeam.name = "H3D: Beam (main)";
				mainBeam(1).expression = H3DreturnBeamMainStartingEndingJS(1);
				mainBeam(2).expression = H3DreturnBeamMainStartingEndingJS(2);
				mainBeam(3).setValue(1);
				mainBeam(4).setValue(0.5);
				mainBeam(5).expression = "effect(\"H3D: Line thickness 1/2\")(\"Point\")[0];";
				mainBeam(6).expression = "thisProperty.propertyGroup(1)(5);";
				mainBeam(7).setValue(0);
				mainBeam(8).expression = "effect(\"H3D: Color 1\")(\"Color\")";
				mainBeam(9).expression = "thisProperty.propertyGroup(1)(8);";
				mainBeam(10).setValue(0);
				mainBeam(11).setValue(1);
				tCount++;
				
				if(H3D.useGroundfill) {
					
					//FLOOR BEAM
					var floorBeam = FX.addProperty("ADBE Laser");
					floorBeam.name = "H3D: Beam (floor)";
					floorBeam(1).expression = H3DreturnBeamFloorStartingEndingJS(1);
					floorBeam(2).expression = H3DreturnBeamFloorStartingEndingJS(2);
					floorBeam(3).setValue(1);
					floorBeam(4).setValue(0.5);
					floorBeam(5).expression = "Math.sqrt(Math.pow(thisComp.width,2) + Math.pow(thisComp.height,2));";
					floorBeam(6).expression = "thisProperty.propertyGroup(1)(5);";
					floorBeam(7).setValue(0);
					floorBeam(8).expression = "effect(\"H3D: Color 3\")(\"Color\");";
					floorBeam(9).expression = "thisProperty.propertyGroup(1)(8);";
					floorBeam(10).setValue(0);
					floorBeam(11).setValue(1);
					tCount++;
					
					var blend = FX.addProperty("ADBE Blend");
					blend.name = "H3D: Blend";
					blend(3).setValue(0.2);
					tCount++;
				
				}
			
				if(H3D.useTriangle)  {
					//TRIANGLE BEAM 1
					var triangle1Beam = FX.addProperty("ADBE Laser");
					triangle1Beam.name = "H3D: Beam (triangle 1)";
					triangle1Beam(1).expression = H3DreturnBeamTriangle1JS(1,1);
					triangle1Beam(2).expression = H3DreturnBeamTriangle1JS(1,2);
					triangle1Beam(3).setValue(1);
					triangle1Beam(4).setValue(0.5);
					triangle1Beam(5).expression = "effect(\"H3D: Line thickness 1/2\")(\"Point\")[1];";
					triangle1Beam(6).expression = "thisProperty.propertyGroup(1)(5);";
					triangle1Beam(7).setValue(0);
					triangle1Beam(8).expression = "effect(\"H3D: Color 2\")(\"Color\");";
					triangle1Beam(9).expression = "thisProperty.propertyGroup(1)(8);";
					triangle1Beam(10).setValue(0);
					triangle1Beam(11).setValue(1);
					tCount++;
					
					//TRIANGLE BEAM 2
					var triangle2Beam = FX.addProperty("ADBE Laser");
					triangle2Beam.name = "H3D: Beam (triangle 2)";
					triangle2Beam(1).expression = H3DreturnBeamTriangle1JS(2,1);
					triangle2Beam(2).expression = H3DreturnBeamTriangle1JS(2,2);
					triangle2Beam(3).setValue(1);
					triangle2Beam(4).setValue(0.5);
					triangle2Beam(5).expression = "effect(\"H3D: Line thickness 1/2\")(\"Point\")[1];";
					triangle2Beam(6).expression = "thisProperty.propertyGroup(1)(5);";
					triangle2Beam(7).setValue(0);
					triangle2Beam(8).expression = "effect(\"H3D: Color 2\")(\"Color\");";
					triangle2Beam(9).expression = "thisProperty.propertyGroup(1)(8);";
					triangle2Beam(10).setValue(0);
					triangle2Beam(11).setValue(1);
					tCount++;
				}
			
				if(H3D.useBaseline) {
					//BASE LINE BEAM
					var triangle1Beam = FX.addProperty("ADBE Laser");
					triangle1Beam.name = "H3D: Beam (base line)";
					triangle1Beam(1).expression = H3DreturnBeamBaseLine(1);
					triangle1Beam(2).expression = H3DreturnBeamBaseLine(2);
					triangle1Beam(3).setValue(1);
					triangle1Beam(4).setValue(0.5);
					triangle1Beam(5).expression = "effect(\"H3D: Line thickness 1/2\")(\"Point\")[1];";
					triangle1Beam(6).expression = "thisProperty.propertyGroup(1)(5);";
					triangle1Beam(7).setValue(0);
					triangle1Beam(8).expression = "effect(\"H3D: Color 2\")(\"Color\");";
					triangle1Beam(9).expression = "thisProperty.propertyGroup(1)(8);";
					triangle1Beam(10).setValue(0);
					triangle1Beam(11).setValue(1);
					tCount++;
				}
			
				H3D.layer.property("Effects").property("H3D: Beam (main)").moveTo(tCount);
							
				H3D.layer.guideLayer = true;
				H3D.layer.locked = true;
				
				app.endUndoGroup();
				
			}
			
		} //function mainFunction()
	
	}//function DoHorizon
	
}